/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.FeatureSet;
import com.sun.speech.freetts.FeatureSetImpl;
import com.sun.speech.freetts.FreeTTSSpeakable;
import com.sun.speech.freetts.Item;
import com.sun.speech.freetts.PathExtractorImpl;
import com.sun.speech.freetts.Relation;
import com.sun.speech.freetts.Token;
import com.sun.speech.freetts.Voice;
import com.sun.speech.freetts.util.SegmentRelationUtils;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class Utterance
implements FeatureSet,
Serializable {
    private Voice voice;
    private FeatureSetImpl features;
    private FeatureSetImpl relations;
    private boolean first;
    private boolean last;
    private FreeTTSSpeakable speakable;

    public Utterance(Voice voice) {
        this.voice = voice;
        this.features = new FeatureSetImpl();
        this.relations = new FeatureSetImpl();
    }

    public Utterance(Voice voice, List tokenList) {
        this(voice);
        this.setTokenList(tokenList);
    }

    public void setSpeakable(FreeTTSSpeakable speakable) {
        this.speakable = speakable;
    }

    public FreeTTSSpeakable getSpeakable() {
        return this.speakable;
    }

    public Relation createRelation(String name) {
        Relation relation = new Relation(name, this);
        this.relations.setObject(name, relation);
        return relation;
    }

    public Relation getRelation(String name) {
        return (Relation)this.relations.getObject(name);
    }

    public boolean hasRelation(String name) {
        return this.relations.isPresent(name);
    }

    public Voice getVoice() {
        return this.voice;
    }

    public void dump(PrintWriter output, int pad, String title, boolean justRelations) {
        output.println(" ============ " + title + " ========== ");
        if (!justRelations) {
            this.voice.dump(output, pad + 4, "Voice");
            this.features.dump(output, pad + 4, "Features");
        }
        this.relations.dump(output, pad + 4, "Relations");
        output.flush();
    }

    public void dump(PrintWriter output, int pad, String title) {
        this.dump(output, pad, title, false);
    }

    public void dump(PrintWriter output, String title) {
        this.dump(output, 0, title, false);
    }

    public void dump(String title) {
        this.dump(new PrintWriter(System.out), 0, title, false);
    }

    public void dumpRelations(String title) {
        this.dump(new PrintWriter(System.out), 0, title, true);
    }

    public boolean isPresent(String name) {
        if (!this.features.isPresent(name)) {
            return this.getVoice().getFeatures().isPresent(name);
        }
        return true;
    }

    public void remove(String name) {
        this.features.remove(name);
    }

    public String getString(String name) {
        if (!this.features.isPresent(name)) {
            return this.getVoice().getFeatures().getString(name);
        }
        return this.features.getString(name);
    }

    public int getInt(String name) {
        if (!this.features.isPresent(name)) {
            return this.getVoice().getFeatures().getInt(name);
        }
        return this.features.getInt(name);
    }

    public float getFloat(String name) {
        if (!this.features.isPresent(name)) {
            return this.getVoice().getFeatures().getFloat(name);
        }
        return this.features.getFloat(name);
    }

    public Object getObject(String name) {
        if (!this.features.isPresent(name)) {
            return this.getVoice().getFeatures().getObject(name);
        }
        return this.features.getObject(name);
    }

    public void setInt(String name, int value) {
        this.features.setInt(name, value);
    }

    public void setFloat(String name, float value) {
        this.features.setFloat(name, value);
    }

    public void setString(String name, String value) {
        this.features.setString(name, value);
    }

    public void setObject(String name, Object value) {
        this.features.setObject(name, value);
    }

    public Item getItem(String relation, float time) {
        Relation segmentRelation = null;
        segmentRelation = this.getRelation("Segment");
        if (segmentRelation == null) {
            throw new IllegalStateException("Utterance has no Segment relation");
        }
        String pathName = null;
        if (!relation.equals("Segment")) {
            if (relation.equals("Syllable")) {
                pathName = "R:SylStructure.parent.R:Syllable";
            } else if (relation.equals("SylStructure")) {
                pathName = "R:SylStructure.parent.parent";
            } else if (relation.equals("Word")) {
                pathName = "R:SylStructure.parent.parent.R:Word";
            } else if (relation.equals("Token")) {
                pathName = "R:SylStructure.parent.parent.R:Token.parent";
            } else if (relation.equals("Phrase")) {
                pathName = "R:SylStructure.parent.parent.R:Phrase.parent";
            } else {
                throw new IllegalArgumentException("Utterance.getItem(): relation cannot be " + relation);
            }
        }
        PathExtractorImpl path = new PathExtractorImpl(pathName, false);
        Item segmentItem = SegmentRelationUtils.getItem(segmentRelation, time);
        if (relation.equals("Segment")) {
            return segmentItem;
        }
        if (segmentItem != null) {
            return path.findItem(segmentItem);
        }
        return null;
    }

    public float getDuration() {
        float duration = -1.0f;
        duration = this.getLastFloat("Segment", "end");
        if (duration == -1.0f && (duration = this.getLastFloat("Target", "pos")) == -1.0f) {
            throw new IllegalStateException("Utterance: Error finding duration");
        }
        return duration;
    }

    private float getLastFloat(String relationName, String feature) {
        Item lastItem;
        float duration = -1.0f;
        Relation relation = this.getRelation(relationName);
        if (relation != null && (lastItem = relation.getTail()) != null) {
            duration = lastItem.getFeatures().getFloat(feature);
        }
        return duration;
    }

    private void setInputText(List tokenList) {
        StringBuffer sb = new StringBuffer();
        Iterator i = tokenList.iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
        }
        this.setString("input_text", sb.toString());
    }

    private void setTokenList(List tokenList) {
        this.setInputText(tokenList);
        Relation relation = this.createRelation("Token");
        Iterator i = tokenList.iterator();
        while (i.hasNext()) {
            Token token = (Token)i.next();
            String tokenWord = token.getWord();
            if (tokenWord == null || tokenWord.length() <= 0) continue;
            Item item = relation.appendItem();
            FeatureSet featureSet = item.getFeatures();
            featureSet.setString("name", tokenWord);
            featureSet.setString("whitespace", token.getWhitespace());
            featureSet.setString("prepunctuation", token.getPrepunctuation());
            featureSet.setString("punc", token.getPostpunctuation());
            featureSet.setString("file_pos", String.valueOf(token.getPosition()));
            featureSet.setString("line_number", String.valueOf(token.getLineNumber()));
        }
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }
}

