import sys
from my_timer import *
from PyQt5.QtWidgets import QApplication, QMainWindow
from PyQt5 import QtCore
from pydub import AudioSegment
from pydub.playback import play
from PyQt5.QtCore import pyqtSignal, QThread


class CloneThread(QThread):
    signal = pyqtSignal('PyQt_PyObject')

    def __init__(self):
        QThread.__init__(self)

    # run method gets called when we start the thread
    def run(self):
        music = AudioSegment.from_mp3(
            "C:\\Users\\tuhin Mitra\\Desktop\\All Python Resources\\gui_project\\emergency_bell_alarm_small_ring.mp3")
        play(music)
        self.signal.emit('')


class Mytimer(QMainWindow):
    def __init__(self):
        super().__init__()
        self.thread1 = CloneThread()
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.timer = QtCore.QTimer()
        self.curr_time = QtCore.QTime(0, 0, 0)  # QtCore.QTime.currentTime()
        print(self.curr_time.toString())
        self.Reach_timer = self.curr_time
        print(f'Reach time:{self.Reach_timer}')
        self.thread1.signal.connect(self.thread1.terminate)
        self.time = QtCore.QTime(self.curr_time)
        self.timer.timeout.connect(self.TimerEvent)
        self.ui.pushButton.clicked.connect(self.terminal)
        # self.timer.start(1000)

    def TimerEvent(self):
        self.time = self.time.addSecs(1)  # add seconds to running time
        if self.time.toString() == self.Reach_timer.toString():  # check if destination is reached
            print('Time Reached')
            self.timer.stop()
            self.thread1.start()
            self.thread1.start()
        self.ui.label.setText(self.time.toString("hh:mm:ss"))
        # print(self.time.toString("hh:mm:ss"))

    def terminal(self):
        button_text = self.ui.pushButton.text()
        if button_text == 'START':
            # self.ui.pushButton.setDisabled(True)
            minutes = int(self.ui.spinBox.text())  # get text from spin box
            self.set_timer = minutes * 60  # converted into seconds
            self.Reach_timer = self.curr_time.addSecs(minutes * 60)  # set the destination
            self.ui.pushButton.setText('STOP')  # set button text for stop
            self.timer.start(1000)  # start timer
        else:
            self.thread1.terminate()
            self.curr_time = QtCore.QTime(0, 0, 0)
            self.time = self.curr_time
            self.ui.pushButton.setText('START')
            self.timer.stop()


if __name__ == '__main__':
    app = QApplication(sys.argv)
    w = Mytimer()
    w.show()
    sys.exit(app.exec_())
